/* --------------------------------------------------------------
  Collection.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Class Collection
 */
export default class Collection {
	/**
	 * Class Constructor
	 */
	constructor() {
		/**
		 * Name
		 *
		 * @type {String}
		 */
		this.name = null;
		
		/**
		 * Title
		 *
		 * @type {String}
		 */
		this.title = null;
		
		/**
		 * Type
		 *
		 * @type {String}
		 */
		this.type = null;
		
		/**
		 * Icon
		 *
		 * @type {String}
		 */
		this.icon = null;
		
		/**
		 * Value
		 *
		 * @type {array}
		 */
		this.entries = null;
	}
	
	/**
	 * Name Getter
	 *
	 * @return {String}
	 */
	getName() {
		return this.name;
	}
	
	/**
	 * Name Setter
	 *
	 * @param {String} name
	 *
	 * @return {Collection}
	 */
	setName(name) {
		StyleEdit.Validator.isString(name);
		this.name = name;
		return this;
	}
	
	/**
	 * Title Getter
	 *
	 * @return {String}
	 */
	getTitle() {
		return this.title;
	}
	
	/**
	 * Title Setter
	 *
	 * @param {String} title
	 *
	 * @return {Collection}
	 */
	setTitle(title) {
		StyleEdit.Validator.isString(title);
		this.title = title;
		return this;
	}
	
	/**
	 * Type Getter
	 *
	 * @return {String}
	 */
	getType() {
		return this.type;
	}
	
	/**
	 * Type Setter
	 *
	 * @param {String} type
	 *
	 * @return {Collection}
	 */
	setType(type) {
		StyleEdit.Validator.isString(type);
		this.type = type;
		return this;
	}
	
	/**
	 * Icon Getter
	 *
	 * @return {String}
	 */
	getIcon() {
		return this.icon;
	}
	
	/**
	 * Icon Setter
	 *
	 * @param {String} icon
	 *
	 * @return {Collection}
	 */
	setIcon(icon) {
		StyleEdit.Validator.isString(icon);
		this.icon = icon;
		return this;
	}
	
	/**
	 * Entries Getter
	 *
	 * @return {Setting[]}
	 */
	getEntries() {
		return this.entries;
	}
	
	/**
	 * Entries Setter
	 *
	 * @param {Setting[]} entries
	 *
	 * @return {Collection}
	 */
	setEntries(entries) {
		StyleEdit.Validator.isObject(entries);
		this.entries = entries;
		return this;
	}
}
